/*:ja
 * @plugindesc 戦闘中立ち絵表示プラグイン(セクハラ攻撃対応)
 * @author TRS
 *
 * @param pictureXpos
 * @desc 戦闘立ち絵グラを表示するX座標
 * @default 0
 *
 * @param pictureYpos
 * @desc 戦闘立ち絵グラを表示するY座標
 * @default 1
 *
 * @param pictureNo
 * @desc 戦闘立ち絵グラのピクチャNO
 * @default 10
 *
 * @param アマブレHPの割合
 * @desc アマブレするHPの割合(0～100)
 * @default 70
 * @type number
 * @min 0
 * @max 100
 *
 * @param 捕まるステート
 * @desc 振りほどくが出るステータス異常
 * @type state
 * @default 26
 *
 * @param 振りほどくコマンド名
 * @desc 捕まった時に攻撃の代わりに出すコマンド名
 * @default 振りほどく
 *
 * @param なすがままコマンド名
 * @desc 捕まった時何もしないコマンド
 * @default なすがまま
 *
 * @param 挑発コマンド名
 * @desc 強制的に敵を捕まえに来させるコマンド名
 * ・ツクールからコマンドタイプ追加で行うと入力ステップが多くなるためここで設定します
 * ・空文字を設定するとこの機能は省略されます
 * @default 挑発
 *
 * @param 挑発時実行コモンイベント
 * @desc 挑発時に実行されるコモンイベント
 * @type common_event
 * @default 208 
*/

(function() {
	
	var parameters = PluginManager.parameters('BattleStandIrast');
	var picXpos = Number(parameters['pictureXpos'] || 0);
	var picYpos = Number(parameters['pictureYpos'] || 0);
	var picNo = Number(parameters['pictureNo'] || 10);
	var varAmaBre = Number(parameters['アマブレHPの割合'] || 70);
	
	var varBressIndex = 0;
	var varBressAnimeCnt = 0;
	
	var sexhraState = Number( parameters['捕まるステート'] || 26 )
	var furihodoku = parameters['振りほどくコマンド名'] || '振りほどく';
	var nasugamama = parameters['なすがままコマンド名'] || 'なすがまま';
	
	var strTyouhatu = parameters['挑発コマンド名'];
	var tyouhatuCommon = Number( parameters['挑発時実行コモンイベント'] || 208 );
	
	var varDamejiPlayer = false;					//プレイヤーダメージフラグ
	
	//-----------------------------------------------------------------------------
	// BattleManager　上書き
	//
	BattleManager.initMembers = function() 
	{
	    this._phase = 'init';
	    this._canEscape = false;
	    this._canLose = false;
	    this._battleTest = false;
	    this._eventCallback = null;
	    this._preemptive = false;
	    this._surprise = false;
	    this._actorIndex = -1;
	    this._actionForcedBattler = null;
	    this._mapBgm = null;
	    this._mapBgs = null;
	    this._actionBattlers = [];
	    this._subject = null;
	    this._action = null;
	    this._targets = [];
	    this._logWindow = null;
	    this._statusWindow = null;
	    this._spriteset = null;
	    this._escapeRatio = 0;
	    this._escaped = false;
	    this._rewards = {};
	    this._turnForced = false;
	    
	    this._picNo = picNo;					//他でとるためここに設定ピクチャ番号入れる
	    this._picXpos = picXpos;				//他でとるためここに設定X座標入れる
	    this._picYpos = picYpos;				//他でとるためここに設定Y座標入れる
	    
	    this._DamegeAnimeCnt = 0;
	    this._index = 0;
	};
	
	/*==============================================
		敵が表れたメッセージの時点で立ち絵出す
	  ==============================================*/
	BattleManager.displayStartMessages = function() 
	{
		ArmarBreakChk();
		SenkouLoad('Actor1_Damege');
		
	    $gameTroop.enemyNames().forEach(function(name) {
	        $gameMessage.add(TextManager.emerge.format(name));
	    });
	    if (this._preemptive) 
	    {
	        $gameMessage.add(TextManager.preemptive.format($gameParty.name()));
	    }
	    else if (this._surprise) 
	    {
	        $gameMessage.add(TextManager.surprise.format($gameParty.name()));
	    }
	};
	
	/*======================================================
		BattleManager.updateを上書き
	  ======================================================*/
	BattleManager.update = function() 
	{
		this.DamegeAnime();
		//PictureBressAnime();
		
	    if (!this.isBusy() && !this.updateEvent()) 
	    {
	        switch (this._phase) 
	        {
	        case 'start':
	            this.startInput();
	            break;
	        case 'turn':
	            this.updateTurn();
	            break;
	        case 'action':
	            this.updateAction();
	            break;
	        case 'turnEnd':
	            this.updateTurnEnd();
	            break;
	        case 'battleEnd':
	            this.updateBattleEnd();
	            break;
	        }
	    }
	};
	
	/*======================================================
		rpgManegerのBattleManager._BattleManager_updateActionを上書き
	  ======================================================*/
	BattleManager.updateAction = function() 
	{
	    var target = this._targets.shift();
	    //PictureBressAnime();
	    ArmarBreakChk( );
	    
	    if (target) 
	    {
	        this.invokeAction(this._subject, target);
	       
	    } else 
	    {
	        this.endAction();
	    }
	};
	
	/*======================================================
		ダメージアニメ
	  ======================================================*/
	BattleManager.DamegeAnime = function() 
	{
		var varShakeTable = [-32,32,32,-32,-16,16,16,-16,-8,8,8,-8,-4,4,4,-4,-2,2,2,-2];
		
		if(varDamejiPlayer === true)
		{
			if( this._DamegeAnimeCnt < 40 )
			{
				this._DamegeAnimeCnt += 1;
				
				//2Fに1回
				if( this._DamegeAnimeCnt % 2 === 0 )
				{
					
					if(this._index < 10)
					{
						ArmarBreakDamegeChk( varShakeTable[this._index] );
						this._index += 1;
					}
				}
				
			}
			else
			{
				varDamejiPlayer = false;
				ArmarBreakChk();
				this._DamegeAnimeCnt = 0;
				this._index = false;
			}
		}
	}
	
	/*======================================================
	 		 バトルログ上書き
	  ======================================================*/
	Window_BattleLog.prototype.displayHpDamage = function(target) 
	{
		isTokusyuMongon = false;
		
	    if (target.result().hpAffected) 
	    {
	        if (target.result().hpDamage > 0 && !target.result().drain) 
	        {
	            this.push('performDamage', target);
	            
	            //敵じゃない
	            if( target.isEnemy() === false)
	            {
	            	varDamejiPlayer = true;			//プレイヤーダメージフラグ
	            }
	            
	            //敵がターゲット
	            else
	            {
					var action = BattleManager._action;
					
					console.log(BattleManager._action);
					//データークラスがスキルの時
	    			if( action._item._dataClass === "skill" )
	    			{
	    				//アクションIDが1(攻撃)じゃない時
				    	if( action._item._itemId !== 1 )
				    	{
				    		isTokusyuMongon = true;
				    	}
	            	}
	            }
	        }
	        
	        if (target.result().hpDamage < 0) 
	        {
	            this.push('performRecovery', target);
	        }
	        
	        if(isTokusyuMongon === false)
	        {
	       		this.push('addText', this.makeHpDamageText(target) );
	       	}
	       	else
	       	{
	       		var result = target.result();
    			var damage = result.hpDamage;
	       		var wrkMessage = target.name() + 'に ' + damage + ' の快感を与えた！';
	       		this.push('addText', wrkMessage );
	       	}
		}
	};
	
	Window_BattleLog.prototype.displayAddedStates = function(target) 
	{
	    target.result().addedStateObjects().forEach(function(state) {
	        var stateMsg = target.isActor() ? state.message1 : state.message2;
	        if (state.id === target.deathStateId()) {
	            this.push('performCollapse', target);
	        }
	        
	        //条件付きで、イったにする
	        if(target.isActor() === false && state.id === target.deathStateId() )
	        {
	        	var action = BattleManager._action;
	        	if( action == BattleManager._action)
    			{
    				//アクションIDが1(攻撃)じゃない時
			    	if( action._item._itemId !== 1 && action._item._dataClass === "skill" )
			    	{
			    		stateMsg = 'はイってしまった！';
			    	}
            	}
	        }
	        
	        if (stateMsg) {
	            this.push('popBaseLine');
	            this.push('pushBaseLine');
	            console.log(stateMsg);
	            this.push('addText', target.name() + stateMsg);
	            this.push('waitForEffect');
	        }
	    }, this);
	};
	
	/**------------------------------------------------------
	 *  ハンドラ追加作成
	 */
	Scene_Battle.prototype.createActorCommandWindow = function() 
	{
	    this._actorCommandWindow = new Window_ActorCommand();
	    this._actorCommandWindow.setHandler('attack', this.commandAttack.bind(this));
	    this._actorCommandWindow.setHandler('skill', this.commandSkill.bind(this));
	    this._actorCommandWindow.setHandler('guard', this.commandGuard.bind(this));
	    this._actorCommandWindow.setHandler('item',  this.commandItem.bind(this));
	    
	    //挑発
	    if(strTyouhatu !== '')
	    	this._actorCommandWindow.setHandler('tyouhatu', this.commandTyouhatu.bind(this) );
	    
	    this._actorCommandWindow.setHandler('cancel', this.selectPreviousCommand.bind(this));
	    
	    this._actorCommandWindow.setHandler('fryAway', this.commandfryAway.bind(this) );
	    this._actorCommandWindow.setHandler('pass', this.commandPass.bind(this));

	    this.addWindow(this._actorCommandWindow);
	};
	
	/**
	 * バトル時
	 */
	
	Scene_Battle.prototype.updateBattleProcess = function() 
	{
		PictureBressAnime();
	    if (!this.isAnyInputWindowActive() || BattleManager.isAborting() ||
	            BattleManager.isBattleEnd()) {
	        BattleManager.update();
	        this.changeInputWindow();
	    }
	};
	
	/**
	 * 振りほどく処理
	 */
	Scene_Battle.prototype.commandfryAway = function() 
	{
		alert("振りほどく");
		
	    this.selectNextCommand();
    }
    
    /**
	 * なすがまま処理
	 */
	Scene_Battle.prototype.commandPass = function() 
	{
		alert("なすがまま");
	    this.selectNextCommand();
    }
    
    /**
	 * 挑発処理
	 */
	Scene_Battle.prototype.commandTyouhatu = function() 
	{
		$gameTemp.reserveCommonEvent(tyouhatuCommon);
	    this.selectNextCommand();
    }
    
	/**------------------------------------------------------
	 *  コマンド作成
	 */
	Window_ActorCommand.prototype.makeCommandList = function() 
	{
    	if (this._actor) 
    	{
	    	//アクター1
	    	if( this._actor._actorId === 1 )
	    	{
	    		if( !$gameActors.actor(1).isStateAffected( sexhraState ) )
	    		{
		        	this.addAttackCommand();
		        	this.addSkillCommands();
		        	//this.addGuardCommand();
		        	this.addItemCommand();
		        	 if(strTyouhatu !== '')
						this.addTyouhatuCommand();
		        }
		        else
		        {
		        	//this.addFryAwayCommand();
		        	//this.addPassComand();
		        }
	        }
		}
    };
	
	/**
	 * 振りほどくコマンド作成
	 */
	Window_ActorCommand.prototype.addFryAwayCommand = function() 
	{
	    this.addCommand( furihodoku, 'fryAway');
	};
	
	/**
	 * なすがままコマンド作成
	 */
	Window_ActorCommand.prototype.addPassComand = function() 
	{
	    this.addCommand( nasugamama, 'pass');
	};
	
	/**
	 * 挑発コマンド作成
	 */
	Window_ActorCommand.prototype.addTyouhatuCommand = function() 
	{
	    this.addCommand( strTyouhatu, 'tyouhatu');
	};
	
	/*=======================================================
	            立ち絵表示
	  =======================================================*/
	function ArmarBreakChk( )
	{
		var strLoadActorPictureName = 'Actor1';
		
		var varBreakHitPoint = (varAmaBre / 100) * $gameActors.actor(1).mhp;				//アマブレHp算出
		
		//アマブレHP
		if( $gameActors.actor(1).hp < varBreakHitPoint)
		{
			SenkouLoad('Actor1_Damege_ab');											//先行ロード
			strLoadActorPictureName += "_ab";
		}
		else
			SenkouLoad('Actor1_Damege');											//先行ロード
			
		
		//捕まってる時は絵の更新をしない
		if( !$gameActors.actor(1).isStateAffected( sexhraState ) )
			$gameScreen.showPicture(picNo, strLoadActorPictureName, 0, picXpos, picYpos, 100, 100, 255, 0);
		
	};
	
	/*=======================================================
	            ダメージグラ表示
	  =======================================================*/
	function ArmarBreakDamegeChk( PosInfo )
	{
		var strLoadActorPictureName = 'Actor1_Damege';
		
		var varBreakHitPoint = (varAmaBre / 100) * $gameActors.actor(1).mhp;				//アマブレHp算出
		
		//アマブレHP
		if( $gameActors.actor(1).hp > varBreakHitPoint)
		{
			strLoadActorPictureName += "_ab";
		}
		else
			SenkouLoad('Actor1_ab');														//先行ロード
			
		//捕まってる時は絵の更新をしない
		if( !$gameActors.actor(1).isStateAffected( sexhraState ) )
			$gameScreen.showPicture(picNo, strLoadActorPictureName, 0, picXpos + PosInfo, picYpos, 100, 100, 255, 0);
	}
	
	/*=================================================
	  		息使い疑似アニメ
	  =================================================*/
	function PictureBressAnime()
	{
		//セクハラステートがついてない時に動く
		if( !$gameActors.actor(1).isStateAffected( sexhraState ) )
		{
			var varBressTable = [1, 2, 3, 4, 5, 5, 5, 4, 3, 2, 1, 0, 0, 0];
			varBressAnimeCnt += 1;
			
			//息継ぎアニメのピクチャ
			if( varBressAnimeCnt % 6 == 0)
			{
				$gameScreen.movePicture(picNo, 0, picXpos, picYpos + varBressTable[ varBressIndex ], 100, 100, 255, 0, 1);
				if( varBressIndex == 13 )
				{
					varBressIndex = 0;
				}
				else
				{
					varBressIndex += 1;
				}
			}
		}
		//セクハラステート中は止める
		else
		{
			$gameScreen.movePicture(picNo, 0, picXpos, picYpos, 100, 100, 255, 0, 1);
		}
	}
	
	/*======================================================
			使用する絵の先行ロード
	  ======================================================*/
	function SenkouLoad( SenkouFileName )
	{
		$gameScreen.showPicture(picNo + 1, SenkouFileName, 0, 0, 0, 100, 100, 0, 0);
		
	}
})();
